#target photoshop-70
// (c) Copyright 2008.  Adobe Systems, Incorporated.  All rights reserved.
/*
@@@BUILDINFO@@@ photoshop_contact_sheet_ii.jsx 1.0.0.5  8-Sept-2021
*/


/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>Adobe Photoshop - Contact Sheet II</dc:title>
     <dc:description>This script enables an optional plug-in called Contact Sheet II and Picture Package.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>Adobe Photoshop - Planche contact II</dc:title>
     <dc:description>Ce script active un module externe facultatif appelé Planche contact II et Collection d'images.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>Adobe Photoshop - コンタクトシート II</dc:title>
     <dc:description>このスクリプトにより、「コンタクトシート II」および「ピクチャパッケージ」というオプションのプラグインが有効になります。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>Adobe Photoshop - Kontaktabzug II</dc:title>
     <dc:description>Mithilfe dieses Skripts werden die optionalen Zusatzmodule ";Kontaktabzug II"; und ";Bildpaket"; aktiviert.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>Adobe Photoshop - Provino a contatto II</dc:title>
     <dc:description>Questo script abilita il plug-in facoltativo per Provino a contatto II e Pacchetto immagini.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>Adobe Photoshop - Hoja de contactos II</dc:title>
     <dc:description>Esta secuencia de comandos activa el plugin opcional denominado Hoja de contactos II y Conjunto de imágenes.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nl_NL">
     <dc:title>Adobe Photoshop - Contactblad II</dc:title>
     <dc:description>Met dit script schakelt u een optionele plug-in in die Contactblad II en Figuurpakket heet.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pt_BR">
     <dc:title>Adobe Photoshop - Página de Amostra II</dc:title>
     <dc:description>Este script habilita um plug-in opcional chamado Página de Amostra II e Pacote de Figuras.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="nb_NO">
     <dc:title>Adobe Photoshop – Kontaktkopi II</dc:title>
     <dc:description>Dette skriptet aktiverer en ekstra plugin-modul som kalles Kontaktkopi II og Bildepakke.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="da_DK">
     <dc:title>Adobe Photoshop - Kontaktaftryk II</dc:title>
     <dc:description>Dette script aktiverer et valgfrit ekstramodul med navnet Kontaktaftryk II og Billedpakke.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fi_FI">
     <dc:title>Adobe Photoshop - Kontaktiarkki II</dc:title>
     <dc:description>Tämä komentosarja ottaa käyttöön valinnaisen plug-in-moduulin nimeltä Kontaktiarkki II ja Kuvanpakkaus.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="sv_SE">
     <dc:title>Adobe Photoshop - Kontaktkarta II</dc:title>
     <dc:description>Det här skriptet aktiverar en valfri plug-in som kallas Kontaktkarta II och Bildpaket.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_TW">
     <dc:title>Adobe Photoshop - 縮圖目錄 II</dc:title>
     <dc:description>此指令碼能啟動一個名為「縮圖目錄 II」和「組合版面」的選擇性增效模組。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="zh_CN">
     <dc:title>Adobe Photoshop - 联系表 II</dc:title>
     <dc:description>该脚本启用名为“联系表 II”和“图片包”的可选增效工具。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KR">
     <dc:title>Adobe Photoshop – 밀착 인화 II</dc:title>
     <dc:description>이 스크립트를 통해 밀착 인화 II 및 사진 패키지라고 하는 선택적 플러그인을 사용할 수 있습니다.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ar_AE">
     <dc:title>Adobe Photoshop - Contact Sheet II</dc:title>
     <dc:description>يمكن البرنامج النصي هذا إضافة اختيارية يطلق عليها Contact Sheet II مع Picture Package.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="cs_CZ">
     <dc:title>Adobe Photoshop – Stránka miniatur II</dc:title>
     <dc:description>Tento skript umožňuje volitelný zásuvný modul Stránka miniatur II a Sada obrazů.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="el_GR">
     <dc:title>Adobe Photoshop - Φύλλο κόντακτ II</dc:title>
     <dc:description>Αυτή η δέσμη ενεργειών ενεργοποιεί την προαιρετική επέκταση Φύλλο κόντακτ II και Συλλογή φωτογραφιών.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_MX">
     <dc:title>Adobe Photoshop - Hoja de contactos II</dc:title>
     <dc:description>Esta secuencia de comandos activa el plugin opcional denominado Hoja de contactos II y Conjunto de imágenes.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_CA">
     <dc:title>Adobe Photoshop - Planche contact II</dc:title>
     <dc:description>Ce script active un module externe facultatif appelé Planche contact II et Collection d'images.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_XM">
     <dc:title>Adobe Photoshop - Planche contact II</dc:title>
     <dc:description>Ce script active un module externe facultatif appelé Planche contact II et Collection d'images.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="he_IL">
     <dc:title>Adobe Photoshop - Contact Sheet II</dc:title>
     <dc:description>סקריפט זה מפעיל תוסף אופציונלי הנקרא Contact Sheet II and Picture Package.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="hu_HU">
     <dc:title>Adobe Photoshop - Indexkép II</dc:title>
     <dc:description>Ez a parancsfájl az Indexkép II és Képcsomag nevű választható bővítmény használatát engedélyezi.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="pl_PL">
     <dc:title>Adobe Photoshop — Stykówka II</dc:title>
     <dc:description>Ten skrypt umożliwia korzystanie z opcjonalnej wtyczki o nazwie Pakiet obrazów i Stykówka II.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ro_RO">
     <dc:title>Adobe Photoshop - Coală de contact II</dc:title>
     <dc:description>Acest script activează un plug-in opţional denumit Coală de contact II şi Pachet imagine.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ru_RU">
     <dc:title>Adobe Photoshop - Контрольный лист II</dc:title>
     <dc:description>Этот сценарий включает дополнения "Контрольный лист II" и "Раскладка изображений".</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="tr_TR">
     <dc:title>Adobe Photoshop - Kişi Sayfası II</dc:title>
     <dc:description>Bu komut dosyası, Kişi Sayfası II ve Resim Paketi adında isteğe bağlı bir eklentiyi etkinleştirir.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="uk_UA">
     <dc:title>Adobe Photoshop - Оглядовий аркуш II</dc:title>
     <dc:description>Цей сценарій активує додаткові модулі ";Оглядовий аркуш II"; та ";Розкладка зображень";.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_AE">
     <dc:title>Adobe Photoshop - Contact Sheet II</dc:title>
     <dc:description>This script enables an optional plug-in called Contact Sheet II and Picture Package.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_IL">
     <dc:title>Adobe Photoshop - Contact Sheet II</dc:title>
     <dc:description>This script enables an optional plug-in called Contact Sheet II and Picture Package.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_MA">
     <dc:title>Adobe Photoshop - Planche contact II</dc:title>
     <dc:description>Ce script active un module externe facultatif appelé Planche contact II et Collection d'images.</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/

try
{ // Overall try catch

//-----------------------------------------------------------------
// Adding this check to CC script revved for CC 2014.1 (15.1), where the photoshop.jsx script is
// being revved to not load in PS CC 2014 for better performance (it will still load then be
// overridden by the 2014 startup script inside of Bridge and other apps). Making this explicit
// check is clearer than failing on undefined 'photoshop'.
//-----------------------------------------------------------------

if (typeof photoshop == "undefined")
	throw localize ("$$$/private/PSBI/Error/PSNotDefined='photoshop' is not defined. Skipping load.");

//=================================================================
// Contact Sheet
// Sets up Photoshop's Contact Sheet automation command to be
// accessed from the Bridge.
//=================================================================

//-----------------------------------------------------------------
// This routine takes an array of files. If called by Photoshop,
// it will invoke Contact Sheet with the files. If called by
// any other app, it will send a BridgeTalk message to Photoshop
// to invoke this routine with the same arguments.
//-----------------------------------------------------------------
photoshop.contactSheet = function (/* Array */ files, availabilityCheckOptions)
	{
	try
		{
		// Make sure this can be run.
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop.versionInfo.btTargetName);
			
			// Create a new BridgeTalk message for Photoshop to invoke
			// Contact Sheet with the selected files
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop.versionInfo.btTargetName;
			btMessage.body = "photoshop.contactSheet (" + files.toSource () + ");";
			btMessage.send ();
			}
		else
			{
			photoshop.runActionCommand ('0B71D221-F8CE-11d2-B21B-0008C75B322C', files);
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// This routine is called when the Bridge's Contact Sheet menu item
// is chosen.
//-----------------------------------------------------------------
photoshop.contactSheetFromBridge = function ()
	{
	try
		{
		// Make sure this can be run.
		var availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		var files = photoshop.getBridgeFileListForAutomateCommand (true, false);
		
		if (files.length != 0)
			photoshop.contactSheet (files, availabilityCheckOptions);
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// The code below inserts the Contact Sheet menu item into the
// Bridge menus. It requires the optional Photoshop ContactSheetII 
// plug-in to be manually installed by the user. Uncomment the following
// Bridge menu insertion code if you want to invoke such functionality
// directly from Bridge.
//-----------------------------------------------------------------

var menuItemInfo = new Object; 

if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion.indexOf (photoshop.versionInfo.bridgeTargetVersion) == 0))
	{	
	// Use temp function to keep vars out of global namespace.
	photoshop.tempFunction = function ()
		{
		// Set up the info necessary for inserting this item into the Bridge's menus later.
		menuItemInfo.text = localize ("$$$/PSBI/Menu/Automate/ContactSheet=Contact Sheet II...");
		menuItemInfo.name = 'ContactSheet';
		menuItemInfo.onSelect = photoshop.contactSheetFromBridge;
		
		photoshop.menuItemInfoArray.push (menuItemInfo);
		}	
	photoshop.tempFunction ();
	delete photoshop.tempFunction;
	}



//=================================================================
// Picture Package
// Sets up Photoshop's Picture Package automation command to be
// accessed from the Bridge.
//=================================================================

//-----------------------------------------------------------------
// This routine takes an array of files. If called by Photoshop,
// it will invoke Picture Package with the files. If called by
// any other app, it will send a BridgeTalk message to Photoshop
// to invoke this routine with the same arguments.
//-----------------------------------------------------------------
photoshop.picturePackage = function (/* Array */ files, availabilityCheckOptions)
	{
	try
		{
		// Make sure this can be run.
		if (availabilityCheckOptions == null)
			availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		if (BridgeTalk.appName != "photoshop")
			{
			// Bring Photoshop to the foreground.
			BridgeTalk.bringToFront (photoshop.versionInfo.btTargetName);
			
			// Create a new BridgeTalk message for Photoshop to invoke
			// Picture Package with the selected files
			var btMessage = new BridgeTalk;
			btMessage.target = photoshop.versionInfo.btTargetName;
			btMessage.body = "photoshop.picturePackage (" + files.toSource () + ");";
			btMessage.send ();
			}
		else
			{
			photoshop.runActionCommand ('4C1ABF40-DD82-11d2-B20F-0008C75B322C', files);
			}
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// This routine is called when the Bridge's Picture Package menu
// item is chosen.
//-----------------------------------------------------------------
photoshop.picturePackageFromBridge = function ()
	{
	try
		{
		// Make sure this can be run.
		var availabilityCheckOptions = new AvailabilityCheckOptions ();
		
		if (!photoshop.correctPSIsAvailable (availabilityCheckOptions))
			return;
		
		var files = photoshop.getBridgeFileListForAutomateCommand (true, false);
		
		if (files.length != 0)
			photoshop.picturePackage (files, availabilityCheckOptions);
		}
	catch (error)
		{
		if (error.number != 8007) // Don't report user cancelled errors.
			alert (error);
		}
	}


//-----------------------------------------------------------------
// The code below inserts the PicturePackage menu item into the
// Bridge menus. It requires the optional Photoshop WebContactSheetII 
// plug-in to be manually installed by the user. Uncomment the following
// Bridge menu insertion code if you want to invoke such functionality
// directly from Bridge.
//-----------------------------------------------------------------

//---------------------------- deferred ---------------------------
// var menuItemInfo2 = new Object;

// if ((BridgeTalk.appName == "bridge") && (BridgeTalk.appVersion.indexOf (photoshop.versionInfo.bridgeTargetVersion) == 0))
// 	{
// 	// Use temp function to keep vars out of global namespace.
// 	photoshop.tempFunction = function ()
// 		{
// 		// Set up the info necessary for inserting this item into the Bridge's menus later.
// 		menuItemInfo2.text = localize ("$$$/PSBI/Menu/Automate/PicturePackage=Picture Package...");
// 		menuItemInfo2.name = 'PicturePackage';
// 		menuItemInfo2.onSelect = photoshop.picturePackageFromBridge;
		
// 		photoshop.menuItemInfoArray.push (menuItemInfo2);
// 		}	
// 	photoshop.tempFunction ();
// 	delete photoshop.tempFunction;
// 	}


//-----------------------------------------------------------------
// The code below adds the optional plug-in to the
// Photoshop sub-menu
//-----------------------------------------------------------------

// Define a function that will sort the menu items for us.
function menuTextOrder (a, b)
	{
	// Pass 'a' into 'b' to get reverse sort order so that they can be
	// added at the top of the menu and still be in alphabetical order
	// (the WAS scripts install additional menu items that end up below
	// these).
	return b.text.toLocaleLowerCase ().localeCompare (a.text.toLocaleLowerCase ());
	}

// Sort the menu items again
photoshop.menuItemInfoArray.sort (menuTextOrder);

// After sorting, find the index of Contact Sheet and place in the correct place of the menu
for(var i=0; i < photoshop.menuItemInfoArray.length; i++){
	if(photoshop.menuItemInfoArray[i].name == menuItemInfo.name){
		var subMenu;
		if(i == photoshop.menuItemInfoArray.length - 1){
			subMenu = MenuElement.create('command', menuItemInfo.text, 'at the beginning of tools/ps', menuItemInfo.name);
		} else if (i == 0){
			subMenu = MenuElement.create('command', menuItemInfo.text, 'at the end of tools/ps', menuItemInfo.name);
		} else {
			subMenu = MenuElement.create('command', menuItemInfo.text, 'after ' + photoshop.menuItemInfoArray[i+1].name, menuItemInfo.name);
		}
		subMenu.onSelect = menuItemInfo.onSelect;
		delete subMenu;
		break;
	}
}
/*
// After sorting, find the index of Picture Package and place in the correct place of the menu
for(var i=0; i < photoshop.menuItemInfoArray.length; i++){
	if(photoshop.menuItemInfoArray[i].name == menuItemInfo2.name){
		var subMenu2;
		if(i == photoshop.menuItemInfoArray.length - 1){
			subMenu2 = MenuElement.create('command', menuItemInfo2.text, 'at the beginning of tools/ps', menuItemInfo2.name);
		} else if (i == 0){
			subMenu2 = MenuElement.create('command', menuItemInfo2.text, 'at the end of tools/ps', menuItemInfo2.name);
		} else {
			subMenu2 = MenuElement.create('command', menuItemInfo2.text, 'after ' + photoshop.menuItemInfoArray[i+1].name, menuItemInfo2.name);
		}
		subMenu2.onSelect = menuItemInfo2.onSelect;
		delete subMenu2;
		break;
	}
}*/


} // Overall try catch
catch (e)
{
	// Debugging
//	alert ("photoshop_contact_sheet_ii.jsx - " + e + ": " + e.line);
}
